/**
 * 
 */
package com.ejie.ab18a.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author XXXX
 * 
 */
public final class GzipUtil {

	private GzipUtil() {
		// no se llama
	}

	public static byte[] compress(String string) throws IOException {
		ByteArrayOutputStream output = new ByteArrayOutputStream(
				string.length());
		GZIPOutputStream gzipOutput = new GZIPOutputStream(output);
		gzipOutput.write(string.getBytes());
		gzipOutput.close();
		byte[] comprimido = output.toByteArray();
		output.close();
		return comprimido;
	}

	public static String decompress(byte[] comprimido) throws IOException {
		final int BUFFER_SIZE = 32;
		ByteArrayInputStream inputStream = new ByteArrayInputStream(comprimido);
		GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream,
				BUFFER_SIZE);
		ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
		byte[] data = new byte[BUFFER_SIZE];
		int bytesRead;
		while ((bytesRead = gzipInputStream.read(data)) != -1) {
			byteOutput.write(data, 0, bytesRead);
		}
		gzipInputStream.close();
		return byteOutput.toString("UTF-8");
	}

}
